IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_Produc_Precio') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_Produc_Precio
END
GO

CREATE FUNCTION [dbo].[CF_Produc_Precio](@pId_Producto VARCHAR(14), @pId_Cliente INT, @pFecha DATETIME, @pId_Contrato INT, @pPorcBonif DECIMAL(9,4), @pTipoRespuesta CHAR(1))
RETURNS DECIMAL(16,4)
AS 
BEGIN

/*
Referencias de parametros de entrada:

@pPorcBonif //Porcentaje de Descuento con prioridad sobre cualquier otro descuento. Ej: 10 = 10% de descuento

@pTipoRespuesta = '' o 'B' //Retorna el Precio con Bonificacion aplicada
@pTipoRespuesta = 'S' //Retorna el Precio sin Bonificacion aplicada
@pTipoRespuesta = 'P' //Retorna el Porcentaje Bonificacion aplicada
*/

/*Variable de Retorno de la Funcion*/
DECLARE @Retorno						DECIMAL(16,4)
/*FIN Variable de Retorono de la Funcion*/


/*Variables Locales*/
DECLARE @JsonEnviar						VARCHAR(8000)
DECLARE @Precio							DECIMAL(12,4)
DECLARE @Precio_Grav					DECIMAL(12,4)
DECLARE @Precio_Exen					DECIMAL(12,4)
DECLARE @Prioridad_Calculo				TINYINT
DECLARE @Id_Lista_Precio_Cliente		SMALLINT
DECLARE @Id_Lista_Precio_Espec_Cliente	INT
DECLARE @Id_Lista_Precio_Contrato		SMALLINT
DECLARE @Precio_Contrato				DECIMAL(12,4)
DECLARE @Precio_Producto				DECIMAL(12,4)
DECLARE @Flag_Precio_For				TINYINT
DECLARE @Flag_Existe_Prod_Cli_Precios	TINYINT
DECLARE @Id_IVA							CHAR(3)
DECLARE @Porc_IVA						DECIMAL(7,4)
DECLARE @Porc_Bonif_Contrato			DECIMAL(5,2)
DECLARE @Porc_Bonif_Prod_Cli_Precios	DECIMAL(5,2)
DECLARE @Porc_Bonif_Lista_Precios_Items	DECIMAL(12,4)
DECLARE @Porc_Bonif_Prod_Listas_Precios_Items_Especial DECIMAL(12,2)
DECLARE @Porc_Bonif_Prod_Listas_Precios_Items_Comun DECIMAL(12,2)
DECLARE @Porc_A_Aplicar					DECIMAL(9,4)
/*FIN Variables Locales*/


/*=================================================================================*/
/*
 * PRIORIDADES DE CALCULO:
 * 
 * 1) Digitado en Contrato
 * 2) Formulado
 * 3) Prod_Cli_Precios
 * 4) Lista de Precios Contrato
 * 5) Lista de Precios Especial Cliente
 * 6) Lista de Precios "Comun" Cliente
 * 7) Producto
*/
SET @Prioridad_Calculo = 0

/*=================================================================================*/

IF(@pId_Producto = '')
BEGIN
	SET @Precio = 0
	RETURN @Precio
END

/*=================================================================================*/

SELECT
		@Flag_Precio_For		= ISNULL(Flag_Precio_For, 0),
		@Precio_Producto		= ISNULL(Precio_Gravado, 0),
		@Id_IVA					= ISNULL(Id_IVA, '')
		FROM Productos
		WHERE
		Id_Producto = @pId_Producto


SELECT
		@Id_Lista_Precio_Cliente		= ISNULL(Id_Lista_Precio, 0),
		@Id_Lista_Precio_Espec_Cliente	= ISNULL(Id_Precio_Especial, 0)
		FROM Clientes
		WHERE
		Id_Cliente = @pId_Cliente


SELECT
		@Id_Lista_Precio_Contrato		= ISNULL(Id_Lista_Precio, 0),
		@Porc_Bonif_Contrato			= ISNULL(Porc_Bonif, 0)
		FROM Contratos
		WHERE
		Id_Contrato = @pId_Contrato

SELECT
		@Porc_IVA						= ISNULL(Porc1, 0)
		FROM Productos_TasaIVA
		WHERE
		Id_IVA = @Id_IVA

SET @Porc_A_Aplicar = 1 --Para multiplicar por defecto por 1

/*=================================================================================*/

IF(@pTipoRespuesta = 'P' AND @pPorcBonif > 0) --Porcentaje Bonificacion aplicada y llega por parametro retorna lo mismo
BEGIN
	RETURN ISNULL(@pPorcBonif, 0)
END

/*=================================================================================*/

/*1) Precio Digitado en Contrato*/

IF(@Prioridad_Calculo = 0 AND @pId_Contrato > 0)
BEGIN
	SELECT
	@Precio_Contrato = ISNULL(Precio, 0)
	FROM Contratos_Prod
	WHERE
	Id_Contrato = @pId_Contrato
	AND Id_Producto = @pId_Producto		

	IF(@Precio_Contrato <> 0)
	BEGIN
		/*Solo se considera que el precio de un contrato prima sobre el resto si es mayor que cero*/
		SET @Prioridad_Calculo = 1
		
		SET @Precio = @Precio_Contrato
		
		IF(@pTipoRespuesta = 'S') --Precio sin Bonificar
		BEGIN
			RETURN ISNULL(@Precio, 0)
		END
		
		IF(@pTipoRespuesta = 'P') --Porcentaje Bonificacion aplicada y el contrato tienen un porcentaje
		BEGIN
			RETURN ISNULL(@Porc_Bonif_Contrato, 0)
		END
		
		IF(@pTipoRespuesta = '' OR @pTipoRespuesta = 'B') --Precio Bonificado
		BEGIN
			IF(@pPorcBonif > 0) --Bonificacion Por parametro
			BEGIN
				SET @Precio = @Precio * ((100 - @pPorcBonif)/100)
			END
			ELSE
			BEGIN
				IF(@Porc_Bonif_Contrato > 0) -- Bonificacion del contrato
				BEGIN
					SET @Precio = @Precio * ((100 - @Porc_Bonif_Contrato)/100)
				END
			END
			
			RETURN ISNULL(@Precio, 0)
		END				
	END
END

/*=================================================================================*/

/*2) Precio Formulado*/

IF(@Prioridad_Calculo = 0 AND @Flag_Precio_For = 1)
BEGIN
	/*Si es formulado aunque el precio sea cero el retorno se devuelve ese*/
	SET @Prioridad_Calculo = 2
		
	SET @JsonEnviar =	'{' +
						dbo.CF_Json_ParsearVariable('Id_Producto', @pId_Producto, 'VARCHAR(14)') + ',' +
						dbo.CF_Json_ParsearVariable('Id_Cliente', @pId_Cliente, 'INT') + ',' +
						dbo.CF_Json_ParsearVariable('Fecha', @pFecha, 'DATETIME') + ',' +
						dbo.CF_Json_ParsearVariable('Id_Contrato', @pId_Contrato, 'INT') + 
						'}'
    SET @Precio = (dbo.CFUJ_Produc_Precio(@JsonEnviar))
    
	IF(@pTipoRespuesta = 'S') --Precio sin Bonificar
	BEGIN
		RETURN ISNULL(@Precio, 0)
	END
    
	IF(@pTipoRespuesta = 'P') --Porcentaje Bonificacion aplicada en caso de Precios formulados no se puede calcular la bonificacion ya que esta embebida en la formula
	BEGIN
		RETURN 0
	END
	
	IF(@pTipoRespuesta = '' OR @pTipoRespuesta = 'B') --Precio Bonificado
	BEGIN
		IF(@pPorcBonif > 0) --Bonificacion Por parametro
		BEGIN
			SET @Precio = @Precio * ((100 - @pPorcBonif)/100)
		END
		
		RETURN ISNULL(@Precio, 0)
	END
END

/*=================================================================================*/

/*3) Precio Prod_Cli_Precios*/

IF(@Prioridad_Calculo = 0 AND @pId_Cliente <> 0)
BEGIN
	SET @Flag_Existe_Prod_Cli_Precios = ISNULL((SELECT MAX(1) FROM Prod_Cli_Precios WHERE Id_Producto = @pId_Producto AND Id_Cliente = @pId_Cliente), 0)

	IF(@Flag_Existe_Prod_Cli_Precios = 1)
	BEGIN
		SET @Prioridad_Calculo = 3
		
		SELECT 
		@Precio							= ISNULL(Precio, 0),
		@Porc_Bonif_Prod_Cli_Precios	= ISNULL(Bonif, 0)
		FROM Prod_Cli_Precios
		WHERE
		Id_Producto = @pId_Producto
		AND Id_Cliente = @pId_Cliente

		IF(@pTipoRespuesta = 'S') --Precio sin Bonificar
		BEGIN
			RETURN ISNULL(@Precio, 0)
		END
	    
		IF(@pTipoRespuesta = 'P') --Porcentaje Bonificacion aplicada
		BEGIN
			RETURN ISNULL(@Porc_Bonif_Prod_Cli_Precios, 0)
		END
		
		IF(@pTipoRespuesta = '' OR @pTipoRespuesta = 'B') --Precio Bonificado
		BEGIN
			IF(@pPorcBonif > 0) --Bonificacion Por parametro
			BEGIN
				SET @Precio = @Precio * ((100 - @pPorcBonif)/100)
			END
			ELSE
			BEGIN
				IF(@Porc_Bonif_Contrato > 0) -- Bonificacion de Prod_Cli_Precios
				BEGIN
					SET @Precio = @Precio * ((100 - @Porc_Bonif_Prod_Cli_Precios)/100)
				END
			END
			
			RETURN ISNULL(@Precio, 0)
		END
	END
END

/*=================================================================================*/

/*4) Precio Lista de Precios Contrato*/

IF(@Prioridad_Calculo = 0 AND @Id_Lista_Precio_Contrato <> 0)
BEGIN
	SET @Flag_Existe_Prod_Cli_Precios = ISNULL((SELECT MAX(1) FROM Prod_Listas_Precios_Items WHERE Id_Producto = @pId_Producto AND Id_Lista_Precio = @Id_Lista_Precio_Contrato), 0)

	IF(@Flag_Existe_Prod_Cli_Precios = 1)
	BEGIN
		SET @Prioridad_Calculo = 4
		
		SELECT 
		@Precio							= ISNULL(Precio, 0),
		@Porc_Bonif_Lista_Precios_Items = ISNULL(Bonificacion, 0)
		FROM Prod_Listas_Precios_Items
		WHERE
		Id_Producto = @pId_Producto
		AND Id_Lista_Precio = @Id_Lista_Precio_Contrato
		
		IF(@pTipoRespuesta = 'S') --Precio sin Bonificar
		BEGIN
			RETURN ISNULL(@Precio, 0)
		END
	    
		IF(@pTipoRespuesta = 'P') --Porcentaje Bonificacion aplicada
		BEGIN
			RETURN ISNULL(@Porc_Bonif_Lista_Precios_Items, 0)
		END
		
		IF(@pTipoRespuesta = '' OR @pTipoRespuesta = 'B') --Precio Bonificado
		BEGIN
			IF(@pPorcBonif > 0) --Bonificacion Por parametro
			BEGIN
				SET @Precio = @Precio * ((100 - @pPorcBonif)/100)
			END
			ELSE
			BEGIN
				IF(@Porc_Bonif_Contrato > 0) -- Bonificacion de Prod_Listas_Precios_Items
				BEGIN
					SET @Precio = @Precio * ((100 - @Porc_Bonif_Lista_Precios_Items)/100)
				END
			END
			
			RETURN ISNULL(@Precio, 0)
		END
	END
END

/*=================================================================================*/

/*5) Precio Lista de Precios Especial Cliente*/

IF(@Prioridad_Calculo = 0 AND @Id_Lista_Precio_Espec_Cliente <> 0)
BEGIN
	SET @Flag_Existe_Prod_Cli_Precios = ISNULL((SELECT MAX(1) FROM Prod_Listas_Precios_Items WHERE Id_Producto = @pId_Producto AND Id_Lista_Precio = @Id_Lista_Precio_Espec_Cliente), 0)

	IF(@Flag_Existe_Prod_Cli_Precios = 1)
	BEGIN
		SET @Prioridad_Calculo = 5
		
		SELECT 
		@Precio = ISNULL(Precio, 0),
		@Porc_Bonif_Prod_Listas_Precios_Items_Especial = ISNULL(Bonificacion, 0)
		FROM Prod_Listas_Precios_Items
		WHERE
		Id_Producto = @pId_Producto
		AND Id_Lista_Precio = @Id_Lista_Precio_Espec_Cliente
		
		IF(@pTipoRespuesta = 'S') --Precio sin Bonificar
		BEGIN
			RETURN ISNULL(@Precio, 0)
		END
	    
		IF(@pTipoRespuesta = 'P') --Porcentaje Bonificacion aplicada
		BEGIN
			RETURN ISNULL(@Porc_Bonif_Prod_Listas_Precios_Items_Especial, 0)
		END
		
		IF(@pTipoRespuesta = '' OR @pTipoRespuesta = 'B') --Precio Bonificado
		BEGIN
			IF(@pPorcBonif > 0) --Bonificacion Por parametro
			BEGIN
				SET @Precio = @Precio * ((100 - @pPorcBonif)/100)
			END
			ELSE
			BEGIN
				IF(@Porc_Bonif_Contrato > 0) -- Bonificacion de Prod_Listas_Precios_Items
				BEGIN
					SET @Precio = @Precio * ((100 - @Porc_Bonif_Prod_Listas_Precios_Items_Especial)/100)
				END
			END
			
			RETURN ISNULL(@Precio, 0)
		END
	END
END

/*=================================================================================*/

/*6) Precio Lista de Precios "Comun" Cliente*/

IF(@Prioridad_Calculo = 0 AND @Id_Lista_Precio_Cliente <> 0)
BEGIN
	SET @Flag_Existe_Prod_Cli_Precios = ISNULL((SELECT MAX(1) FROM Prod_Listas_Precios_Items WHERE Id_Producto = @pId_Producto AND Id_Lista_Precio = @Id_Lista_Precio_Cliente), 0)

	IF(@Flag_Existe_Prod_Cli_Precios = 1)
	BEGIN
		SET @Prioridad_Calculo = 6
		
		SELECT 
		@Precio = ISNULL(Precio, 0),
		@Porc_Bonif_Prod_Listas_Precios_Items_Comun = ISNULL(Bonificacion, 0)
		FROM Prod_Listas_Precios_Items
		WHERE
		Id_Producto = @pId_Producto
		AND Id_Lista_Precio = @Id_Lista_Precio_Cliente
		
		IF(@pTipoRespuesta = 'S') --Precio sin Bonificar
		BEGIN
			RETURN ISNULL(@Precio, 0)
		END
	    
		IF(@pTipoRespuesta = 'P') --Porcentaje Bonificacion aplicada
		BEGIN
			RETURN ISNULL(@Porc_Bonif_Prod_Listas_Precios_Items_Comun, 0)
		END
		
		IF(@pTipoRespuesta = '' OR @pTipoRespuesta = 'B') --Precio Bonificado
		BEGIN
			IF(@pPorcBonif > 0) --Bonificacion Por parametro
			BEGIN
				SET @Precio = @Precio * ((100 - @pPorcBonif)/100)
			END
			ELSE
			BEGIN
				IF(@Porc_Bonif_Contrato > 0) -- Bonificacion de Prod_Listas_Precios_Items
				BEGIN
					SET @Precio = @Precio * ((100 - @Porc_Bonif_Prod_Listas_Precios_Items_Comun)/100)
				END
			END
			
			RETURN ISNULL(@Precio, 0)
		END		
	END
END

/*=================================================================================*/

/*7) Precio Producto*/
IF(@Prioridad_Calculo = 0)
BEGIN
	SET @Prioridad_Calculo = 7
	
	SET @Precio = @Precio_Producto	
	
	IF(@pTipoRespuesta = 'S') --Precio sin Bonificar
	BEGIN
		RETURN ISNULL(@Precio, 0)
	END
    
	IF(@pTipoRespuesta = 'P') --Porcentaje Bonificacion aplicada en caso de Productos no existe
	BEGIN
		RETURN 0
	END
	
	IF(@pTipoRespuesta = '' OR @pTipoRespuesta = 'B') --Precio Bonificado
	BEGIN
		IF(@pPorcBonif > 0) --Bonificacion Por parametro
		BEGIN
			SET @Precio = @Precio * ((100 - @pPorcBonif)/100)
		END
		
		RETURN ISNULL(@Precio, 0)
	END
END

/*=================================================================================*/


RETURN 0 /*Tiene que haber salido por un RETURN anterior*/
END
